

*---------------------------------Pension for Life (P4L) ---------------------------------*
**
* This program caculates lifetime costs if veterans presently receiving NVC benefits transition to Pension for Life.
**

********* Past DA discount for new PSC monthly compensation ********** 
* methodology derived from 'https://indd.adobe.com/view/3b5fd5b4-f603-45e4-b7f4-a9fb8cc411de'
									
										
*assigns past da amounts*										
										
gen da_past= 0 										
replace	 da_past=   (da/100)	*	365400 if  year_r ==	2018		
replace  da_past=	(da/100)	*	360000 if   year_r ==	2017		
replace	 da_past=	(da/100)	*	354679.8 if year_r ==	2016		
replace	 da_past=	(da/100)	*	350128.13 if  year_r ==	2015		
replace	 da_past=	(da/100)	*	343937.26 if  year_r ==	2014		
replace	 da_past=	(da/100)	*	340531.94 if  year_r ==	2013		
replace	 da_past=	(da/100)	*	334510.75 if  year_r ==	2012		
replace	 da_past=	(da/100)	*	325083.33 if  year_r ==	2011		
replace	 da_past=	(da/100)	*	319649.29 if  year_r ==	2010		
replace	 da_past=	(da/100)	*	318375.79 if  year_r ==	2009		
replace	 da_past=	(da/100)	*	310307.79 if  year_r ==	2008		
replace	 da_past=	(da/100)	*	303925.36 if  year_r ==	2007		
replace	 da_past=	(da/100)	*	297674.2 if  year_r ==	2006

		
										
* calculates number of monthly payment* 
*assumes half year payment*										
										
gen month_r =0										
replace month_r	= 6	 if year_r ==2018					
replace  month_r	= 18 	if year_r ==	2017					
replace  month_r	= 	30 	if year_r ==	2016					
replace  month_r	= 	42 	if year_r ==	2015					
replace  month_r	= 	54 	if year_r ==	2014					
replace  month_r	= 	66 	if year_r ==	2013					
replace  month_r	= 	78 	if year_r ==	2012					
replace  month_r	= 	90 	if year_r ==	2011					
replace  month_r	= 	102 if year_r ==	2010					
replace  month_r	= 	114 if year_r ==	2009					
replace  month_r	= 	126 if year_r ==	2008					
replace  month_r	= 	138 if year_r ==	2007					
replace  month_r	= 	150 if year_r ==	2006					

*monthly equivalent  (assumes mid year receipt)*
gen mpsc_eq = (1150*da/100)* month_r

gen extra = da_past - mpsc_eq
* turns the exta received in anuity discount* 
 gen psc_offset = extra /( (1/(i-g))* (1- ((1+g)/(1+i))^life))
 
  gen psc_offset_m = psc_offset/12
 gen psc_net= max(((1150*da/100)*12)  - psc_offset, 0) 
 gen psc_y = ((1150*da/100)*12)
*gives percentage of growth
 
 gen dap4l_y5 =  dpgrowth*5 
 
 
 gen psc_y5 =dap4l_y5/100 * 1150 * 12*(1+g)^5 
 
 gen npv_psc_net = 0
 
replace npv_psc_net =  psc_net*(1/(i-g))* (1- ((1+g)/(1+i))^life) 


 ****growth treated as a different anuity ***
gen npv_psc_5 =0 
replace npv_psc_5 = psc_y5 *(1/(i-g))* (1- ((1+g)/(1+i))^(life-5))*1/(1+i)^5 if psc_y5>0 

 gen npv_psc = npv_psc_net + npv_psc_5

 
 
 
 
 
 
**********************APSC********************************* 
* grade directly from cia grades*
gen apsc_0 = 0
replace apsc_0 = 500 if ciagrade==3
replace apsc_0 = 1000 if ciagrade==2
replace apsc_0 = 1500 if ciagrade==1

gen apsc_y = apsc_0*12



gen npv_apsc = 0
replace npv_apsc = apsc_y* (1/(i-g))* (1- ((1+g)/(1+i))^life) if  apsc_y>0

**********************IRB********************************* 
* subscratin employment earnings from offsets up to 20,000$*
gen netoff =totoffset + max(earn-20000/12, 0) - earn  
replace netoff = 0 if netoff ==.
gen Ap4l = 0.9*max(minsalary/12,militarysalary)
gen Bp4l= 0
replace Bp4l = netoff 

gen IRB_0y = max(Ap4l-Bp4l,0)*12*fedtax 

*TEMP*
gen npv_irb_temp = 0
replace npv_irb_temp =IRB_0y * (1/(i-g))* (1- ((1+g)/(1+i))^(3)) if elbelig == 2 & age<65 & IRB_0y>0

*EXTENDED*

gen cpyear = max( min(60-age, 20-release-serv_y),0)
gen npv_IRB_65=0

forval y = 0/45 { 
gen npv_IRB_`y' = 0
replace npv_IRB_`y' = max( Ap4l-Bp4l,0)*(cpi)^`y'*12 *1/(1+i)^`y' if (age+`y')<65 &elbelig==1
replace npv_IRB_`y' = max( (Ap4l*1.031^`y' )-(Bp4l*cpi^`y'),0)*12*1/(1+i)^`y' if (age+`y')<60 & (cpyear-`y')>0 & elbelig==1
 } 
 
 gen npv_IRBcp_65 = 0 
forval y = 0/45 { 
 replace npv_IRBcp_65 = npv_IRB_`y' + npv_IRBcp_65 
 } 
 replace npv_IRB_65 = npv_IRBcp_65 
********************IRB POST 65*****************************

gen irb_eligpost65  = 0
 * if we assume earnings stop, sisip stops and oas starts***
replace irb_eligpost65 = 1 if elbelig==1  &( 0.7 * max(minsalary/12,militarysalary)) > (totoffset -earn - sisipincomeforclient+ 586*cpi)
gen irbpost65 = max(( 0.7 *0.9* max(minsalary/12,militarysalary)) - (totoffset -earn - sisipincomeforclient+ 586*cpi),0)
gen irbpost65_cp =0 
replace irbpost65_cp = max((( 0.7 *0.9* max(minsalary/12,militarysalary))*(1+g+0.01)^(cpyear)) - ((totoffset -earn - sisipincomeforclient+ 586*cpi)*(1+g)^(cpyear)),0)
gen npv_irb_p65 = 0

replace npv_irb_p65 = (irbpost65*(1+g)^(65-age) *12* (1/(i-g))* (1- ((1+g)/(1+i))^(life-(65-age) )))/(1+i)^(65-age) if irb_eligpost65 == 1
replace npv_irb_p65 = (irbpost65_cp*(1+g)^(65-age-cpyear) *12* (1/(i-g))* (1- ((1+g)/(1+i))^(life-(65-age) )))/(1+i)^(65-age) if irb_eligpost65 == 1 & cpyear>0

**********************IRB SURVIVOR***************************

*OAS not an offset anymore, pensions are reduced to 50%, cpp to 60%**


gen s_irb= max(( 0.7 *0.9* max(minsalary/12,militarysalary)) - (totoffset -earn - sisipincomeforclient - 0.5*(allpensions)),0)
gen npv_s_irb=0
replace npv_s_irb = (irbpost65-0.4*(max(cpporrrqincomeforclient,0)))*(1+g)^(life) *12 * (1/(i-g))* (1- ((1+g)/(1+i))^(slife-life ))*1/(1+i)^(life) if npv_irb_p65>0 & mstat==1 & slife>life




************************IRB TOTAL****************************** 

gen npv_IRB = npv_IRB_65 + npv_irb_p65 +  npv_irb_temp +npv_s_irb

*grandfathering of old amounts 
replace npv_IRB = npv_ELB + npv_cias if (npv_cias + npv_ELB)> ( npv_IRB)

****************caregiver************

gen npv_carep4l = 0 
replace npv_carep4l = 12000* (1/(i-g))* (1- ((1+g)/(1+i))^life) if caregiver==1

