# High-net-worth Family Database (HFD)
PBO’s *High-net-worth Family Database* (HFD) contains the microdata PBO used to produce an estimate of the wealth of Canadian families worth millions and billions of dollars. This iteration of HFD was constructed using publicly available data from year-end 2016, and scaled up to year-end 2019 using data from the Quarterly Demographic Estimates and the National Balance Sheet Accounts.

HFD is available in the following microdata files. For more information, including on concepts, data sources, and modelling approaches, users should refer to PBO’s report, “[Estimating the Top Tail of the Family Wealth Distribution in Canada](https://pbo-dpb.gc.ca/en/blog/news/RP-2021-007-S--estimating-top-tail-family-wealth-distribution-in-canada--estimation-queue-superieure-distribution-patrimoine-familial-au-canada)”. The use and interpretation of the data contained in HFD is entirely the responsibility of users.

HFD contains information adapted from Statistics Canada, Survey of Financial Security: Public Use Microdata File, 2016. This does not constitute an endorsement by Statistics Canada of this product.

|Resource|Format|Language|Links|
|--- |--- |--- |--- |
|High-net-worth Family Database|.dta|English|HFD_2019_en.dta|
|High-net-worth Family Database|.dta|French|BDFE _2019_fr.dta|
|High-net-worth Family Database|.csv<br>.pdf|English|HFD_2019_en.csv<br>HFD_2019_variable_names_en.pdf|
|High-net-worth Family Database|.csv<br>.pdf|French|BDFE _2019_fr.txt<br>BDFE_2019_noms_de_variables_fr.pdf|

## Additional information
 - Date published: 2020-11-03
 - Date modified: 2020-11-03

## Contact
[Office of the Parliamentary Budget Officer](https://www.pbo-dpb.gc.ca) 
(613-992-8026; pbo-dpb@parl.gc.ca)

----------

# Base de données sur les familles à valeur nette élevée (BDFE)

La Base de données sur les familles à valeur nette élevée (BDFE) du DPB contient les microdonnées que ce dernier a utilisé pour dresser une estimation du patrimoine des familles canadiennes dont la valeur nette se chiffre en millions et en milliards de dollars. Cette itération de la BDFE a été élaborée à partir de données publiées à la fin de l’année 2016, et mise à l'échelle de la fin de l'année 2019 en utilisant les données des Estimations démographiques trimestrielles et des Comptes du bilan national. 

La BDFE est disponible dans les fichiers de microdonnées suivants. Pour obtenir plus d’informations, notamment sur les concepts, les sources des données et les approches de modélisation, les utilisateurs devraient consulter au rapport du DPB intitulé « [Estimation de la queue supérieure de la distribution du patrimoine familial au Canada](https://pbo-dpb.gc.ca/fr/blog/news/RP-2021-007-S--estimating-top-tail-family-wealth-distribution-in-canada--estimation-queue-superieure-distribution-patrimoine-familial-au-canada) ». L’utilisation et l’interprétation des données contenues dans la BDFE relèvent entièrement de la responsabilité des utilisateurs.

La BDFE contient des données adaptées de Statistique Canada, Enquête sur la sécurité financière : fichier de microdonnées à grande diffusion, 2016. Cela ne constitue pas une approbation de ce produit par Statistique Canada. 

|Ressource|Format|Langage|Liens|
|--- |--- |--- |--- |
|Base de données sur les familles à valeur nette élevée|.dta|Français|BDFE_2019_fr.dta|
|Base de données sur les familles à valeur nette élevée|.dta|Anglais|HFD_2019_en.dta|
|Base de données sur les familles à valeur nette élevée|.csv<br>.pdf|Français|BDFE _2019_fr.csv<br>BDFE_2019_noms_de_variables_fr.pdf|
|Base de données sur les familles à valeur nette élevée|.csv<br>.pdf|Anglais|HFD_2019_en.csv<br>HFD_2019_variable_names_en.pdf|

## Informations supplémentaires

 - Date de publication : 2020-11-03
 - Date de modification : 2020-11-03

## Contact
[Bureau du directeur parlementaire du budget ](https://www.pbo-dpb.gc.ca) 
(613-992-8026; pbo-dpb@parl.gc.ca)
